/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.util.helper;

import dev.toma.gunsrpg.api.common.IAmmoProvider;
import dev.toma.gunsrpg.common.init.ModTags;
import dev.toma.gunsrpg.common.item.GrenadeItem;
import dev.toma.gunsrpg.common.item.heal.AbstractHealItem;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public final class StorageUtil {
    public static boolean isFood(ItemStack stack) {
        Food food = stack.func_77973_b().func_219967_s();
        return food != null;
    }

    public static boolean isAmmo(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof IAmmoProvider) {
            IAmmoProvider provider = (IAmmoProvider)item;
            return !provider.getAmmoType().isExplosive();
        }
        return false;
    }

    public static boolean isExplosive(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof IAmmoProvider) {
            return ((IAmmoProvider)item).getAmmoType().isExplosive();
        }
        return item instanceof GrenadeItem || item.func_206844_a(ModTags.Items.EXPLOSIVE_ITEM);
    }

    public static boolean isMed(ItemStack stack) {
        return stack.func_77973_b().func_206844_a(ModTags.Items.HEALING_ITEM) || stack.func_77973_b() instanceof AbstractHealItem;
    }

    public static boolean notAnInventory(ItemStack stack) {
        if (stack.func_77973_b().func_206844_a(ModTags.Items.INVENTORY_ITEM)) {
            return false;
        }
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null) {
            return !nbt.func_74764_b("BlockEntityTag") && !nbt.func_74764_b("Items");
        }
        LazyOptional optional = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        return !optional.isPresent();
    }

    public static boolean isCrystal(ItemStack stack) {
        return stack.func_77973_b().func_206844_a(ModTags.Items.PERK);
    }

    private StorageUtil() {
    }
}

